/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.entities;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import projectvibrantjourneys.common.entities.IBucketCollectable;
import projectvibrantjourneys.init.object.PVJItems;
import projectvibrantjourneys.init.object.PVJSoundEvents;

public class StarfishEntity
extends WaterMobEntity
implements IBucketCollectable {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(StarfishEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(StarfishEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(StarfishEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final int NUM_COLORS = 5;

    public StarfishEntity(EntityType<? extends StarfishEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 2.0).func_233815_a_(Attributes.field_233821_d_, 0.05);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.5));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(COLOR, (Object)0);
        this.func_184212_Q().func_187214_a(FROM_BUCKET, (Object)false);
        this.func_184212_Q().func_187214_a(CLIMBING, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Color", this.getColor());
        compound.func_74757_a("FromBucket", this.isFromBucket());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setColor(compound.func_74762_e("Color"));
        this.setFromBucket(compound.func_74767_n("FromBucket"));
    }

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR);
    }

    public void setColor(int color) {
        this.func_184212_Q().func_187227_b(COLOR, (Object)color);
    }

    public int getRandomColor(Random rand) {
        return rand.nextInt(5);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.func_201670_d()) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.func_184212_Q().func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.func_184212_Q().func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.func_184212_Q().func_187227_b(CLIMBING, (Object)b0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        if (dataTag != null && dataTag.func_150297_b("BucketVariantTag", 3)) {
            this.setColor(dataTag.func_74762_e("BucketVariantTag"));
        } else {
            this.setColor(this.getRandomColor(world.func_201674_k()));
        }
        BlockPos pos = this.func_233580_cy_();
        while (world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == Blocks.field_150355_j) {
            this.func_70107_b(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
            pos = this.func_233580_cy_();
        }
        return super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new ClimberPathNavigator((MobEntity)this, worldIn);
    }

    protected void func_209207_l(int air) {
    }

    public static boolean canSpawn(EntityType<StarfishEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return pos.func_177956_o() > 60;
    }

    public static boolean canSpawnOcean(EntityType<StarfishEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return pos.func_177956_o() < world.func_181545_F();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 0;
    }

    protected void func_85033_bc() {
    }

    public boolean func_225511_J_() {
        return this.isFromBucket();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.isFromBucket() && !this.func_145818_k_();
    }

    @Override
    public boolean isFromBucket() {
        return (Boolean)this.func_184212_Q().func_187225_a(FROM_BUCKET);
    }

    @Override
    public void setFromBucket(boolean value) {
        this.func_184212_Q().func_187227_b(FROM_BUCKET, (Object)value);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151131_as && this.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            ItemStack itemstack1 = this.getFishBucket();
            this.setBucketData(itemstack1);
            if (!this.field_70170_p.func_201670_d()) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, itemstack1);
            }
            if (itemstack.func_190926_b()) {
                player.func_184611_a(hand, itemstack1);
            } else if (!player.field_71071_by.func_70441_a(itemstack1)) {
                player.func_71019_a(itemstack1, false);
            }
            this.func_70106_y();
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    @Override
    public void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
        CompoundNBT compoundnbt = bucket.func_196082_o();
        compoundnbt.func_74768_a("BucketVariantTag", this.getColor());
    }

    @Override
    public ItemStack getFishBucket() {
        return new ItemStack((IItemProvider)PVJItems.starfish_bucket);
    }

    protected SoundEvent func_184639_G() {
        String name;
        if (this.func_145818_k_() && ((name = this.func_200201_e().getString().toLowerCase()).equals("patrick") || name.equals("patrick star") || name.equals("patrickstar"))) {
            return PVJSoundEvents.PATRICK_STAR;
        }
        return null;
    }
}

